/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core;

import com.aptana.php.debug.core.preferences.PHPDebugPreferencesUtil;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;

public class HostsCollector {
    private HostsCollector() {
    }

    public static String getHosts() {
        String clientIP = PHPDebugPreferencesUtil.getString("com.aptana.php.debug.eplclient_ip", "");
        if (clientIP.length() != 0) {
            return clientIP;
        }
        try {
            ArrayList<InetAddress> localHosts = new ArrayList<InetAddress>();
            ArrayList<InetAddress> allIPs = new ArrayList<InetAddress>();
            Enumeration<NetworkInterface> networkInterfacesEnumeration = NetworkInterface.getNetworkInterfaces();
            while (networkInterfacesEnumeration.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfacesEnumeration.nextElement();
                String name = networkInterface.getName();
                Enumeration<InetAddress> InetAddressesEnumeration = networkInterface.getInetAddresses();
                while (InetAddressesEnumeration.hasMoreElements()) {
                    InetAddress inetAddress = InetAddressesEnumeration.nextElement();
                    if (inetAddress instanceof Inet6Address) continue;
                    if (name.equalsIgnoreCase("lo") || name.equalsIgnoreCase("localhost")) {
                        localHosts.add(inetAddress);
                        continue;
                    }
                    allIPs.add(inetAddress);
                }
            }
            allIPs.addAll(localHosts);
            if (allIPs.size() > 0) {
                StringBuilder buf = new StringBuilder();
                int i = 0;
                while (i < allIPs.size()) {
                    InetAddress inetAddress;
                    String s;
                    if (i > 0) {
                        buf.append("%2C");
                    }
                    if ((s = (inetAddress = (InetAddress)allIPs.get(i)).toString()).startsWith("/")) {
                        s = s.substring(1);
                    }
                    buf.append(s);
                    ++i;
                }
                return buf.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }
}

